/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWSIMShiftsTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    public static final int COL_NAME = 0;
    private static int m_nShiftNameCount = 0;
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_rowData = null;

    public VWSIMShiftsTableModel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_rowData = new Vector();
    }

    public void reinitialize() {
        int shiftCount;
        m_nShiftNameCount = 0;
        this.m_rowData.removeAllElements();
        Object[] shiftDefs = this.m_propertyData.getScenarioDefinition().getShifts();
        if (shiftDefs != null && (shiftCount = shiftDefs.length) > 0) {
            try {
                VWQubbleSort qubbleSort = new VWQubbleSort();
                VWQubbleSort.sort(shiftDefs);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
            for (int i = 0; i < shiftCount; ++i) {
                this.m_rowData.addElement(shiftDefs[i]);
            }
        }
        this.fireTableDataChanged();
    }

    public VWScenarioShiftDefinition getItemAt(int nRowIndex) {
        try {
            int rowDataCount = this.m_rowData.size();
            if (rowDataCount > 0 && nRowIndex >= 0 && nRowIndex < rowDataCount) {
                return (VWScenarioShiftDefinition)this.m_rowData.elementAt(nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void addItem() {
        VWScenarioShiftDefinition newShiftDef = null;
        try {
            String name = null;
            Date scenarioStartDateTime = (Date)this.m_propertyData.getScenarioDefinition().getStartTime();
            boolean success = false;
            while (!success) {
                name = VWSIMResource.s_shift + ++m_nShiftNameCount;
                try {
                    newShiftDef = this.m_propertyData.getScenarioDefinition().createShift(name);
                    newShiftDef.setShiftType(1);
                    newShiftDef.setStartTime(scenarioStartDateTime.getTime());
                    success = true;
                }
                catch (Exception ex) {}
            }
            this.m_rowData.addElement(newShiftDef);
            this.m_propertyData.setDirty();
            this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 120, newShiftDef);
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void copyItem(int row) {
        try {
            VWScenarioShiftDefinition shiftDef = this.getItemAt(row);
            if (shiftDef != null) {
                String name = VWSIMResource.s_copyOf + " " + shiftDef.getName();
                VWScenarioShiftDefinition newShiftDef = this.m_propertyData.getScenarioDefinition().createShift(name, shiftDef);
                this.m_rowData.addElement(newShiftDef);
                this.m_propertyData.setDirty();
                this.fireTableRowsInserted(this.m_rowData.size(), this.m_rowData.size());
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 120, newShiftDef);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int row) {
        try {
            VWScenarioShiftDefinition shiftDef = this.getItemAt(row);
            String name = shiftDef.getName();
            this.m_propertyData.getScenarioDefinition().deleteShift(name);
            this.m_rowData.removeElementAt(row);
            this.m_propertyData.setDirty();
            this.fireTableRowsDeleted(row, row);
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 121, shiftDef);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        Object resultClass = null;
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWSIMResource.s_name;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            VWScenarioShiftDefinition shiftDef = this.getItemAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (shiftDef != null) {
                        return shiftDef.getName();
                    }
                    return new String("");
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                this.onUpdateName(value, row);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            VWScenarioShiftDefinition shiftDef;
            String name = (String)aValue;
            if (name != null && name.length() > 0 && (shiftDef = this.getItemAt(nRowIndex)) != null) {
                String oldName = shiftDef.getName();
                shiftDef.setName(name);
                this.m_propertyData.setDirty();
                String[] names = new String[]{oldName, name};
                this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 122, names);
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }
}

